%buttons_radio
% GUI for experiment options

% num repetitions per round
load('.\InitiationFiles\repetitions_ini.txt');
num_rounds_core_stimulus_set=repetitions_ini(1);
num_rounds_extra_stimulus_set=repetitions_ini(2);                    

figure(num_logical_monitors); % researcher window
axis off

SoundCardBgroup=uibuttongroup('Title','Sound Card',...
                        'FontSize',14,...
                        'Units','normalized',...
                        'Position',[.2 .7 .25 .2]);
SoundCardB=uicontrol('Style','Listbox',...
                        'String',board_names,...
                        'Value',cardindex_default,...
                        'Min',1,'Max',1,...
                        'Units','normalized',...
                        'Position',[.1 .2 .8 .6],...
                        'Parent',SoundCardBgroup);
                    
                   
IncIPAB=uicontrol('Style','Radio',...
                        'String','Display IPA symbols',...
                        'Value',0,...
                        'Units','normalized',...
                        'Position',[.2 .6 .25 .05]);

skipInstructionsB=uicontrol('Style','Radio',...
                        'String','Skip instructions',...
                        'Value',0,...
                        'Units','normalized',...
                        'Position',[.2 .5 .25 .05]);

CoreNumB=uicontrol('Style','Listbox',...
                        'String',{'1','2','3','4','5','6','7','8','9','10'},...
                        'Value',num_rounds_core_stimulus_set,...
                        'Min',1,'Max',1,...
                        'Units','normalized',...
                        'Position',[.2 .35 .1 .1]);
ExtraNumB=uicontrol('Style','Listbox',...
                        'String',{'0','1','2','3','4','5','6','7','8','9','10'},...
                        'Value',num_rounds_extra_stimulus_set+1,...
                        'Min',1,'Max',1,...
                        'Units','normalized',...
                        'Position',[.2 .225 .1 .1]);     
text(.225,.35,'Core stimuli Number of Rounds');
text(.225,.225,'Extra stimuli Number of Rounds');
axis off
                    
nextb_ref=toc+.1;
nextb=0;
button_next;
while nextb<nextb_ref
    pause(.1)
end


cardindex_default=get(SoundCardB,'Value');
cardname_in=board_names{cardindex_default};

display_IPA=get(IncIPAB,'Value');

skipInstructions=get(skipInstructionsB,'Value');

num_rounds_core_stimulus_set=get(CoreNumB,'Value');
num_rounds_extra_stimulus_set=get(ExtraNumB,'Value')-1;

playsoundfile('./Instructions/Click.wav','async')
clf(num_logical_monitors)