% logistic_regression_Alvarez
%
% (c) 2007 Geoffrey Stewart Morrison
% Version of 12 December 2007
%
% THIS IS AN INTERIM VERSION, DEVELOPMENT OF ADDITIONAL FEATURES IS PLANNED
%
% This software runs the logistic regression analyses of the lvarez Gonzlez (1980) data performed in:
%       Morrison, G. S. (2007). 
%       Logistic regression modelling for first- and second-language perception data. 
%       In M. J. Sol, P. Prieto, & J. Mascar(Eds.), 
%       Segmental and prosodic issues in Romance phonology (pp. 219--236).
%       Amsterdam: John Benjamins.
%
% To understand this software, please read the Morrison (2007) paper
% and references cited therein.
%
% This software has been tested and runs succesfully on:
%   Matlab Release 2007b running on Windows XP Professional x64
%   The Statistics Toolbox is required
%
% This version uses the  multivariate multinomial logistic regression function
% from the Statistics Toolbox, but gives the same results as the multivariate 
% logistic regression software programmed by Terrance M. Nearey.
%
% A first-time user may simply wish to run the this script, setting the
% "compareG2" option to either "false" or "true" to get the results reported in
% the Morrison (2007) paper.
% Programmers may wish to adapt the scripts and functions provided here in
% order to conduct their own analyses on new data.

clear all

compareG2 = true;
default_model = 1;

models = {'F1+F2' 'F1+F2+F3' 'F1+F2+F1*F2'};
if ~compareG2, models = models(default_model); end


% load stimulus properties and response data
load('stimprops.txt');  stimcols = {'F1' 'F2' 'F3'}; % values are in logHz
load('responses.txt');  respcols = {'a' 'e' 'i' 'o' 'u'};

% format input for multinomial logistic regression function
response_matrix = responses(:,2:end) + .1; % includes addition of a small amount to each cell
temp_stim_matrix = stimprops(responses(:,1),2:end);

for Imodel = 1:length(models)
    % format input according to model to be texted
    [stim_matrix, var_string] = parse_model(temp_stim_matrix, stimcols, models{Imodel});

    % multinomial logistic regression
    [B, G2, stats] = mnrfit(stim_matrix, response_matrix, 'interactions', 'on');

    % calculate deviation-from-mean coefficient values
    B_redundant = [B, zeros(size(B,1),1)];
    B_mean = repmat( mean(B_redundant,2), [1 size(B_redundant,2)]);
    B_deviation_from_mean = B_redundant - B_mean;

    disp('------------------------')
    disp(models{Imodel})
    fprintf('G2: %0.0f \tdf: %0.0f \n',G2,stats.dfe)
    disp(respcols)
    disp(B_deviation_from_mean)
end %for Imodel = 1:length(models)
