% logistic_regression_VOT
%
% (c) 2007 Geoffrey Stewart Morrison
% Version of 12 December 2007
%
% This software runs the logistic regression analyses of the hypothetical VOT data performed in:
%       Morrison, G. S. (2007). 
%       Logistic regression modelling for first- and second-language perception data. 
%       In M. J. Sol, P. Prieto, & J. Mascar(Eds.), 
%       Segmental and prosodic issues in Romance phonology (pp. 219--236).
%       Amsterdam: John Benjamins.
%
% To understand this software, please read the Morrison (2007) paper
% and references cited therein.
%
% This software has been tested and runs succesfully on:
%   Matlab Release 2007b running on Windows XP Professional x64
%   The Statistics Toolbox is required
%
% This version uses the  multivariate multinomial logistic regression function
% from the Statistics Toolbox, but gives the same results as the multivariate 
% logistic regression software programmed by Terrance M. Nearey.
%
% A first-time user may simply wish to run the this script.
% Programmers may wish to adapt the scripts and functions provided here in
% order to conduct their own analyses on new data.


% load stimulus properties and response data
load('stimprops.txt');  stimcols = {'VOT (ms)'};
load('responses.txt');  respcols = {'voiced' 'voiceless'};

% format input for multinomial logistic regression function
stim_matrix = stimprops(responses(:,1),2:end);
response_matrix = responses(:,2:end);

% multinomial logistic regression
B = mnrfit(stim_matrix, response_matrix);

% plots
p_obs = response_matrix .* repmat( 1./sum(response_matrix,2), [1 size(response_matrix,2)]);

plot_matrix = (0:60)';
p_hat = mnrval(B, plot_matrix);
logit_hat = glmval(B, plot_matrix, 'identity');

subplot(2,1,1);
plot(plot_matrix,logit_hat,'g')
set(gca,'PlotBoxAspectRatio',[2 1 1])
xlim([0 60])
ylim([-10 10])
xlabel(stimcols{1});
ylabel('logits');

subplot(2,1,2);
plot(plot_matrix,p_hat(:,1),'b')
hold on
plot(plot_matrix,p_hat(:,2),'b')
plot(stim_matrix,p_obs(:,1),'.r')
hold off
xlim([0 60])
ylim([-0.2 1.2])
set(gca,'PlotBoxAspectRatio',[2 1 1],'YTick',[0,.25,.5,.75,1])
xlabel(stimcols{1});
ylabel('proportion');


